/**
  ******************************************************************************
  * @file    cp_client.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   connection establishment code, client side
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 

#include "project.h"

#include "cp.h"

/** @brief Executes the client connect-perform communication-release connection loop.
 *
 *  @param p_Ipv4Address Peeraddress (IPv4 format)
 *  @param p_PeerPort target TCP end point
 *  @param p_Processor communication processor
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 */

CP_STATUSCODE cp_CommLoopClient(unsigned long p_Ipv4Address,unsigned short p_PeerPort,PCP_PROCESSOR p_Processor)
{
    CP_STATUSCODE a_Return = CP_STATUSCODE_FATAL;
    int a_WorkerSocket;
    struct sockaddr_in a_Address;
    if ((a_WorkerSocket = socket(AF_INET, SOCK_STREAM, 0)) >= 0) 
    {
        a_Address.sin_family = AF_INET;
        a_Address.sin_port = htons(p_PeerPort);
        a_Address.sin_addr.s_addr = htonl(p_Ipv4Address);
        a_Return = CP_STATUSCODE_CONNLOSS;
        if (connect(a_WorkerSocket,(struct sockaddr *)&a_Address,sizeof(a_Address)) >= 0)
        {
            int a_timeout = 100; /* 1000 msecs */          
            if (setsockopt(a_WorkerSocket, SOL_SOCKET, SO_RCVTIMEO, &a_timeout, sizeof(a_timeout)) == 0)
            {
                p_Processor->m_Socket = a_WorkerSocket;
                // signal the receiver task that the socket to read from is now valid
                xTaskNotifyGive( p_Processor->m_AssociatedReceiverTask );
                // this will initiate c->s authentication
                cp_QueuePacketToComm(p_Processor,TAG_AUTHREQUEST,CP_MAGIC_NUMBER_AUTHENTICATION,CP_PRIQUEUE_MEDIUMPRI);
                a_Return = cp_HandleEstablishedComm(p_Processor);
            } // could set a timeout
        } // connect succeeded
        shutdown(a_WorkerSocket,SHUT_RDWR);
        close(a_WorkerSocket);
    } // could connect to peer
    return a_Return;
}
